/**
* \file: AilAudioSourceImpl.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Android Auto
*
* \author: I. Hayashi / ADITJ/SW / ihayashi@jp.adit-jv.com
*          D. Girnus  / ADITG/ESM / dgirnus@de.adit-jv.com
*
* \copyright (c) 2016-2017 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/
#ifndef AILAUDIOSOURCEIMPL_H
#define AILAUDIOSOURCEIMPL_H

#include <memory>

#include <AudioStreaming.h>

#include <aauto/AudioSource.h>
#include <aauto/GalReceiver.h>
#include <aauto/util/scoped_ptr.h>
#include <aauto/util/shared_ptr.h>
#include <aauto/util/Thread.h>

#include "aauto/AditAudioSource.h"
#include <uspi/ConfigHandle.h>

#define NSEC_PER_SEC                (1000ULL * 1000ULL * 1000ULL)

#define MICROPHONE_WORTH_OF_SAMPLE_MS   10
#define MICROPHONE_SAMPLING_RATE        16000
#define MICROPHONE_BITS_PER_SAMPLE      16
#define MICROPHONE_CHANNELS             1

namespace adit { namespace utility { namespace audio {
class Backend;
}; }; };

namespace adit { namespace aauto
{

class AilSourceConfig : public uspi::ConfigHandle
{
public:
AilSourceConfig()
{
    mSampleRate = 0;
    mInitToutms = 0;
    mNumBits = 0;
    mNumChannels = 0;
    mVerbose = 0;
    mDisablePrio = 0;
    mThreadPrio = 0;
    mPeriodms = 0;
    mBufferperiods = 0;
    mSilencems = 0;
    mDevice = "";
}

bool ResultConfig()
{
    bool isValid = true;
    mSampleRate     = getInt("audio-source-sampling-rate", &isValid, Range(-1, INT_MAX), MICROPHONE_SAMPLING_RATE);
    mNumBits        = getInt("audio-source-bits-per-sample", &isValid, Range(-1, INT_MAX), MICROPHONE_BITS_PER_SAMPLE);
    mNumChannels    = getInt("audio-source-channels", &isValid, Range(-1, INT_MAX), MICROPHONE_CHANNELS);
    mVerbose        = getInt("enable-verbose-logging", &isValid, Range(0, 1), 0);
    mDisablePrio    = getInt("disable-real-time-priority-audio", &isValid, Range(0, 1), 0);
    mThreadPrio     = getInt("audio-threads-real-time-priority", &isValid, Range(-1, INT_MAX), 61);
    
    mPeriodms       = getIntMultiKey("audio-capture-device", "periodms", &isValid, Range(-1, INT_MAX));
    mBufferperiods  = getIntMultiKey("audio-capture-device", "bufferperiods", &isValid, Range(-1, INT_MAX), -1);
    mSilencems      = getIntMultiKey("audio-capture-device", "silencems", &isValid, Range(-1, INT_MAX), -1);
    mInitToutms     = getIntMultiKey("audio-capture-device", "inittoutms", &isValid, Range(-1, INT_MAX), -1);
    mDevice         = getStringMultiKey("audio-capture-device", "device", &isValid, Range(-1, INT_MAX));

    return isValid;
}
    int     mSampleRate;        // Sampling rate
    int     mNumBits;           // Bits per sample
    int     mNumChannels;       // Number of Channels

    bool    mVerbose;           // Verbose log flag
    bool    mDisablePrio;       // Priority Set flag
    int     mThreadPrio;        // Thread Priority
    string  mAilSourceSetting;  // AIL Common settings data

    /* AIL device setting */
    int     mInitToutms;
    int     mPeriodms;
    int     mBufferperiods;
    int     mSilencems;
    string  mDevice;
};

class AilAudioSourceImpl : public IAudioSourceCallbacks, public utility::audio::Streaming
{
public:
    AilAudioSourceImpl(AudioSource* inSource);
    ~AilAudioSourceImpl();

    bool init();
    void shutdown();

    void setConfigItem(string inKey, string inValue);
    void registerCallbacks(IAditAudioSourceCallbacks* inCallbacks);

protected:
    /* IAudioSourceCallbacks */
    void ackCallback(int sessionId, uint32_t ack);
    int microphoneRequestCallback(bool open, bool ancEnabled,
            bool ecEnabled, int maxUnacked);

    /* AIL streaming callbacks */
    utility::audio::AudioState processing(unsigned char *in, unsigned char **out, uint32_t &frames) final;

    void error(const std::string& data) const final;
    void warning(const std::string& data) const final;
    void info(const std::string& data) const final;
    void debug(const std::string& data) const final;
    utility::eLogLevel checkLogLevel() const final;

    void statistics(const utility::audio::StreamStatistics &status) final;
    void eostreaming(const utility::audio::AudioError error) final;

private:
    /**
     * @brief  Helper API to get the current time stamp
     */
    uint64_t getTimestamp(void);
    /**
     * @brief  Helper API to get the current configuration
     *         and set the internal members (e.g.mSampleRate, etc.)
     */
    bool getCurrConfig(void);
    /**
     * @brief Helper API, called in case of microphoneRequestCallback(open==true) from MD.
     *        Prepares AIL device and starts MicrophoneReaderThread.
     */
    bool start(int maxUnacked);
    /**
     * @brief Helper API, called in case of microphoneRequestCallback(open==false) from MD
     *        or shutdown triggered by Application.
     *        Stop and release AIL device and joins the MicrophoneReaderThread.
     */
    void stop();
    /**
     * @brief Helper API, called by helper function start().
     *        Set up the AIL device by using the configuration set by Application.
     */
    bool prepare();

    /* to handle states */
    bool mShutdown;
    bool mStarted;

    /* to identify session */
    string mSourceName;
    int mSessionId;

    IAditAudioSourceCallbacks* mCallbacks;
    AudioSource* audioSource;

    /* IoBuffer with audio data */
    ::shared_ptr<IoBuffer> mData;

    /* configuration */
    AilSourceConfig  mConfig;

    /* AIL */
    std::shared_ptr<utility::audio::Backend> mBackend;
};
} } /* namespace adit { namespace aauto */

#endif // AILAUDIOSOURCEIMPL_H
